<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'email', 'phone_number', 'status', 'country_code_id', 'last_login_ip', 'last_login_at');

    public function countryCode()
    {
        return $this->belongsTo('App\Models\CountryCode');
    }

    public function carts()
    {
        return $this->hasMany('App\Models\Cart');
    }

    public function reviews()
    {
        return $this->belongsTo('App\Models\Review');
    }

    public function socialAccounts()
    {
        return $this->hasMany('App\Models\SocialAccount');
    }

    public function notificationSettings()
    {
        return $this->belongsToMany('App\Models\NotificationSetting');
    }

    public function shippingAddresses()
    {
        return $this->hasMany('App\Models\ShippingAddress');
    }

}